﻿unit Email_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const
Array_Items_EMA_AND_AQUAMAIL: TSQL_Table_array = (
 (sql_col: 'DNT_when_date';                   fex_col: 'When Date';                         read_as: ftLargeInt;   convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_Subject';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_preview_utf8';                fex_col: 'Preview Utf8';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_who_from';                    fex_col: 'Who From';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_who_reply_to';                fex_col: 'Who Reply To';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_who_to';                      fex_col: 'Who To';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_who_cc';                      fex_col: 'Who Cc';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_who_bcc';                     fex_col: 'Who Bcc';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_msg_id';                      fex_col: 'Msg Id';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_AND_GMAIL: TSQL_Table_array = (
 (sql_col: 'DNT_ZIPPED_MESSAGE_PROTO';        fex_col: 'ZIPPED_MESSAGE_PROTO';              read_as: ftString;     convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Date Received';                     read_as: ftString;     convert_as: '';                col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TO';                          fex_col: 'To';                                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FROM';                        fex_col: 'From';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEPREVIEW';              fex_col: 'Message Preview';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEID';                   fex_col: 'Message ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEBODY';                 fex_col: 'Message Body';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_AND_GMAIL_OFFLINE: TSQL_Table_array = (
 (sql_col: 'DNT_RECEIVEDDATEMS';              fex_col: 'Received';                          read_as: ftFloat;      convert_as: 'UNIX_MS';         col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ADDRESS_FROM';                fex_col: 'From';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ADDRESS_TO';                  fex_col: 'To';                                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SNIPPETHTML';                 fex_col: 'Snippet';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BODY';                        fex_col: 'Body';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONVERSATIONID';              fex_col: 'Conversation ID';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_AND_PROTONMAIL: TSQL_Table_array = (
 (sql_col: 'DNT_TIME';                        fex_col: 'Timestamp';                         read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_SENDER_SENDERNAME';           fex_col: 'Sender Name';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SENDER_SENDERSERIALIZED';     fex_col: 'Sender Serialized';                 read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MIMETYPE';                    fex_col: 'MIME Type';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SIZE';                        fex_col: 'Size';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TYPE';                        fex_col: 'Type';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ADDRESSID';                   fex_col: 'Address ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONVERSATIONID';              fex_col: 'Conversation ID';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HEADER';                      fex_col: 'Headers';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ID';                          fex_col: 'ID#';                               read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_ISDOWNLOADED';                fex_col: 'Is Downloaded';                     read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ISENCRYPTED';                 fex_col: 'Is Proton Encrypted';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ISFORWARDED';                 fex_col: 'Is Forwarded';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ISREPLIED';                   fex_col: 'Is Replied';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ISREPLIEDALL';                fex_col: 'Is Replied All';                    read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LABELIDS';                    fex_col: 'Label IDs';                         read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_LOCATION';                    fex_col: 'Proton Location';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_NUMATTACHMENTS';              fex_col: 'Attachments';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_UNREAD';                      fex_col: 'Unread';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_IOS_GMAIL: TSQL_Table_array = (
 (sql_col: 'DNT_ZIPPED_MESSAGE_PROTO';        fex_col: 'ZIPPED_MESSAGE_PROTO';              read_as: ftString;     convert_as: '';                col_type: ftString;    show: False),
 (sql_col: 'DNT_TIMESTAMP';                   fex_col: 'Date Received';                     read_as: ftString;     convert_as: '';                col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TO';                          fex_col: 'To';                                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FROM';                        fex_col: 'From';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEPREVIEW';              fex_col: 'Message Preview';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEID';                   fex_col: 'Message ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGEBODY';                 fex_col: 'Message Body';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_IOS_GMAIL_OFFLINE_SEARCH: TSQL_Table_array = (
 (sql_col: 'DNT_TO';                          fex_col: 'To';                               read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_FROM';                        fex_col: 'From';                             read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                          read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BODY';                        fex_col: 'Body';                             read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CC';                          fex_col: 'CC';                               read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_BCC';                         fex_col: 'BCC';                              read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ITEMSERVERPERMID';            fex_col: 'Thread ID';                        read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGESERVERPERMID';         fex_col: 'Message ID';                       read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                         read_as: ftString;      convert_as: '';                col_type: ftString;    show: True),
);

Array_Items_EMA_IOS_MAIL: TSQL_Table_array = (
 (sql_col: 'DNT_DATE_SENT';                   fex_col: 'Date Sent';                         read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_RECEIVED';               fex_col: 'Date Received';                     read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_SENDER_TEXT';                 fex_col: 'Sender';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT_TEXT';                fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SNIPPET';                     fex_col: 'Snippet';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'Mailbox';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONVERSATION_ID';             fex_col: 'Conversation ID';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGE_ID';                  fex_col: 'Message ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SIZE';                        fex_col: 'Size';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_READ';                        fex_col: 'Read';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DELETED';                     fex_col: 'Is Deleted';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_IOS_MAIL_LIBRARY: TSQL_Table_array = (
 (sql_col: 'DNT_DATE_SENT';                   fex_col: 'Date Sent';                         read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_RECEIVED';               fex_col: 'Date Received';                     read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_SENDER';                      fex_col: 'Sender';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUMMARY';                     fex_col: 'Snippet';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'Mailbox';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONVERSATION_ID';             fex_col: 'Conversation ID';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGE_ID';                  fex_col: 'Message ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'Mailbox';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SIZE';                        fex_col: 'Size';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_READ';                        fex_col: 'Read';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DELETED';                     fex_col: 'Is Deleted';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_IOS_MAIL_MAILDATA: TSQL_Table_array = (
 (sql_col: 'DNT_DATE_SENT';                   fex_col: 'Date Sent';                         read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_DATE_RECEIVED';               fex_col: 'Date Received';                     read_as: ftLargeInt;   convert_as: 'UNIX';            col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_SENDER';                      fex_col: 'Sender';                            read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SUBJECT';                     fex_col: 'Subject';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SNIPPET';                     fex_col: 'Snippet';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ATTACHMENTS';                 fex_col: 'Attachments';                       read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'Mailbox';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_CONVERSATION_ID';             fex_col: 'Conversation ID';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MESSAGE_ID';                  fex_col: 'Message ID';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_MAILBOX';                     fex_col: 'Mailbox';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SIZE';                        fex_col: 'Size';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_READ';                        fex_col: 'Read';                              read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DELETED';                     fex_col: 'Is Deleted';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_IOS_MAIL_ADDRESSES: TSQL_Table_array = (
 (sql_col: 'DNT_ADDRESS';                     fex_col: 'Address';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_COMMENT';                     fex_col: 'Comment';                           read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_EMA_OUTLOOK_HISTORY: TSQL_Table_array = (
 (sql_col: 'DNT_LAST_VISIT_TIME';             fex_col: 'Last Visit Time';                   read_as: ftString;     convert_as: 'DTChrome';        col_type: ftDateTime;  show: True),
 (sql_col: 'DNT_TITLE';                       fex_col: 'Title';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TYPED_COUNT';                 fex_col: 'Outlook Typed Count';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_URL';                         fex_col: 'URL';                               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_VISIT_COUNT';                 fex_col: 'Outlook Visit Count';               read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_ID';                          fex_col: 'ID#';                               read_as: ftInteger;    convert_as: '';                col_type: ftInteger;   show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
);

Array_Items_EMA_NEW_OUTLOOK_INDEXEDDB: TSQL_Table_array = (
 (sql_col: 'DNT_LASTDELIVERYTIME';            fex_col: 'Last Delivery Time';                read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_DISPLAYNAME';                 fex_col: 'Display Name';                      read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_TOPIC';                       fex_col: 'Topic';                             read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_IMPORTANCE';                  fex_col: 'Importance';                        read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_HASATTACHMENTS';              fex_col: 'Has Attachments';                   read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_EXCHANGE_ID';                 fex_col: 'MS Exchange ID';                    read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 (sql_col: 'DNT_SQLLOCATION';                 fex_col: 'Location';                          read_as: ftString;     convert_as: '';                col_type: ftString;    show: True),
 );

Array_Items_NULL: TSQL_Table_array = (
 (sql_col: '';
 fex_col: '';
 read_as: ftString;
 convert_as: '';
 col_type: ftString;
 show: false));

begin
   if Name = 'EMA_AND_AQUAMAIL'                            then Result := Array_Items_EMA_AND_AQUAMAIL else
   if Name = 'EMA_AND_GMAIL'                               then Result := Array_Items_EMA_AND_GMAIL else
   if Name = 'EMA_AND_GMAIL_OFFLINE'                       then Result := Array_Items_EMA_AND_GMAIL_OFFLINE else
   if Name = 'EMA_AND_PROTONMAIL'                          then Result := Array_Items_EMA_AND_PROTONMAIL else
   if Name = 'EMA_IOS_GMAIL'                               then Result := Array_Items_EMA_IOS_GMAIL else
   if Name = 'EMA_IOS_GMAIL_OFFLINE_SEARCH'                then Result := Array_Items_EMA_IOS_GMAIL_OFFLINE_SEARCH else
   if Name = 'EMA_IOS_MAIL_V6'                             then Result := Array_Items_EMA_IOS_MAIL else // Same as below
   if Name = 'EMA_IOS_MAIL_V7'                             then Result := Array_Items_EMA_IOS_MAIL else // Same display ^
   if Name = 'EMA_IOS_MAIL_MAILDATA'                       then Result := Array_Items_EMA_IOS_MAIL_MAILDATA else
   if Name = 'EMA_IOS_MAIL_LIBRARY'                        then Result := Array_Items_EMA_IOS_MAIL_LIBRARY else
   if Name = 'EMA_IOS_MAIL_ADDRESSES'                      then Result := Array_Items_EMA_IOS_MAIL_ADDRESSES else
   if Name = 'EMA_NEW_OUTLOOK_INDEXEDDB'                   then Result := Array_Items_EMA_NEW_OUTLOOK_INDEXEDDB else
   if Name = 'EMA_OUTLOOK_HISTORY'                         then Result := Array_Items_EMA_OUTLOOK_HISTORY else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Email' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
